//-------------------------------------------------------------------------
//			ActionMedia II Programmer's Toolkit
//	
//			Windows Motion Player Sample Program
//	
//Header Name:	copylist.h
//
//Description:	header file for copylist.c
//	
//	Copyright Intel Corp. 1991, 1992
//	All Rights Reserved.
//				
//-------------------------------------------------------------------------

#ifndef COPYLIST_H
#define	COPYLIST_H	1

#define	NUM_CLIP_RECTS	100
#define	NUM_COPY_BOXES	200

typedef struct tagCOPYLIST {
	HAVK	hConn;						// handle of connector to be clipped
	HWND	hwndTarget;					// window handle of target window
	RECT	rectTarget;					// target rect coords
	RECT	rectClipList[NUM_CLIP_RECTS];	// array to build clip list
	WORD	ClipCnt;					// Number of elements in clip list
} COPYLIST;

//	Error eturned by UpdateCopyList() if Clip2Copy() is in error. Any
//	other non-zero return is an AVK error.

#define	COPY_ERROR	(I16)0xffff

#ifndef COPYLIST_NOEXTERNS
extern I16	UpdateCopyList(COPYLIST *pCL, RECT *pTarget, WORD cxView, 
				WORD cyView, BOOL *pbUpdated);
#endif

#endif		// #ifndef COPYLIST_H


